/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl;

import java.awt.Canvas;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;

public class CanvasFocusTest
extends JFrame {
    private static final long serialVersionUID = 2853176700479564421L;
    private JMenuBar menuBar;
    private Canvas canvas;
    private Thread gameThread;
    private boolean running;

    private JInternalFrame createDebugFrame() {
        JInternalFrame internalFrame = new JInternalFrame("Debug Frame");
        internalFrame.setLayout(new FlowLayout(1));
        internalFrame.setSize(400, 100);
        internalFrame.setVisible(true);
        JButton focus = new JButton("Focus");
        focus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CanvasFocusTest.this.canvas.setFocusable(true);
            }
        });
        internalFrame.add(focus);
        JButton unfocus = new JButton("Unfocus");
        unfocus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CanvasFocusTest.this.canvas.setFocusable(false);
            }
        });
        internalFrame.add(unfocus);
        JButton metal = new JButton("Metal");
        metal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CanvasFocusTest.this.switchMetal();
            }
        });
        internalFrame.add(metal);
        JButton substance = new JButton("Substance");
        substance.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CanvasFocusTest.this.switchSubstance();
            }
        });
        internalFrame.add(substance);
        return internalFrame;
    }

    private JInternalFrame createGameFrame() {
        final JInternalFrame canvasFrame = new JInternalFrame("Game Frame");
        canvasFrame.setSize(800, 600);
        canvasFrame.setLocation(80, 80);
        canvasFrame.setVisible(true);
        this.canvas = new Canvas(){

            public void addNotify() {
                super.addNotify();
                CanvasFocusTest.this.startLWJGL();
            }

            public void removeNotify() {
                CanvasFocusTest.this.stopLWJGL();
                super.removeNotify();
            }
        };
        canvasFrame.add(this.canvas);
        this.canvas.setSize(canvasFrame.getContentPane().getSize());
        this.canvas.setFocusable(true);
        this.canvas.requestFocus();
        this.canvas.setIgnoreRepaint(true);
        canvasFrame.addInternalFrameListener(new InternalFrameListener(){

            public void internalFrameOpened(InternalFrameEvent e) {
                SwingUtilities.getWindowAncestor(canvasFrame).validate();
            }

            public void internalFrameClosing(InternalFrameEvent e) {
                SwingUtilities.getWindowAncestor(canvasFrame).validate();
            }

            public void internalFrameClosed(InternalFrameEvent e) {
                SwingUtilities.getWindowAncestor(canvasFrame).validate();
            }

            public void internalFrameIconified(InternalFrameEvent e) {
                SwingUtilities.getWindowAncestor(canvasFrame).validate();
            }

            public void internalFrameDeiconified(InternalFrameEvent e) {
                SwingUtilities.getWindowAncestor(canvasFrame).validate();
            }

            public void internalFrameActivated(InternalFrameEvent e) {
                SwingUtilities.getWindowAncestor(canvasFrame).validate();
            }

            public void internalFrameDeactivated(InternalFrameEvent e) {
                SwingUtilities.getWindowAncestor(canvasFrame).validate();
            }
        });
        canvasFrame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                SwingUtilities.getWindowAncestor(canvasFrame).validate();
            }

            public void componentMoved(ComponentEvent e) {
                SwingUtilities.getWindowAncestor(canvasFrame).validate();
            }
        });
        Thread thread = new Thread(){

            /*
             * Unable to fully structure code
             */
            public void run() {
                block2: while (true) {
                    if (!Mouse.isCreated()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    while (true) {
                        if (Mouse.next()) ** break;
                        continue block2;
                        wheelD = Mouse.getDWheel();
                        if (wheelD == 0) continue;
                        System.out.println("" + wheelD);
                    }
                    break;
                }
            }
        };
        thread.start();
        return canvasFrame;
    }

    protected void gameLoop() {
        GL11.glClearColor((float)1.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        Boolean active = null;
        while (this.running) {
            GL11.glClear((int)16640);
            Display.update();
            Display.sync((int)60);
            boolean a = Display.isActive();
            if (active != null && active == a) continue;
            System.out.println("Diplay.isActive() = " + a + " - " + this.canvas.isFocusOwner());
            active = a;
        }
        Display.destroy();
    }

    public void init() {
    }

    protected void initGL() {
    }

    private void loadSwing() {
        this.switchSubstance();
        this.menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        file.add(new JMenuItem("Item 1"));
        file.add(new JMenuItem("Item 2"));
        file.add(new JMenuItem("Item 3"));
        this.menuBar.add(file);
        this.setJMenuBar(this.menuBar);
        JDesktopPane desktop = new JDesktopPane();
        this.add(desktop);
        JInternalFrame canvasFrame = this.createGameFrame();
        desktop.add(canvasFrame);
        JInternalFrame debugFrame = this.createDebugFrame();
        desktop.add(debugFrame);
        this.setSize(1024, 768);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    public void start() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                CanvasFocusTest.this.loadSwing();
            }
        });
    }

    public void startLWJGL() {
        this.gameThread = new Thread(){

            public void run() {
                CanvasFocusTest.this.running = true;
                try {
                    Display.setParent((Canvas)CanvasFocusTest.this.canvas);
                    Display.create();
                    CanvasFocusTest.this.initGL();
                }
                catch (LWJGLException e) {
                    e.printStackTrace();
                    return;
                }
                CanvasFocusTest.this.gameLoop();
            }
        };
        this.gameThread.start();
    }

    private void stopLWJGL() {
        Display.destroy();
    }

    protected void switchMetal() {
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
            UIManager.getLookAndFeelDefaults().put("ClassLoader", this.getClass().getClassLoader());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
    }

    protected void switchSubstance() {
        UIManager.getLookAndFeelDefaults().put("ClassLoader", this.getClass().getClassLoader());
        SwingUtilities.updateComponentTreeUI(this);
    }

    public static void main(String[] args) {
        new CanvasFocusTest().start();
    }
}

