/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.PrivilegedActionException;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;

public class Test_glGetVertexAttribPointer_API_bug {
    static boolean crashJvm = "true".equals(System.getProperty("crashJvm", "false"));
    static final int FLOAT_BYTES = 4;
    static AttrGen gen = new AttrGen();
    static final Attr position = gen.allocAttr("position", 1, 3);
    static final Attr normal = gen.allocAttr("normal", 2, 3);
    static final Attr textureCoordinates = gen.allocAttr("textureCoordinates", 3, 2);
    static final int stride = Test_glGetVertexAttribPointer_API_bug.gen.offset;
    static final int strideBytes = stride * 4;
    static final Attr[] attributes = new Attr[]{position, normal, textureCoordinates};

    static long getBufferAddress(ByteBuffer buf) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method m = BufferUtils.class.getDeclaredMethod("getBufferAddress", Buffer.class);
        if (!m.isAccessible()) {
            m.setAccessible(true);
        }
        return (Long)m.invoke(null, buf);
    }

    static long glGetVertexAttribPointer(int index) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        int result_size = PointerBuffer.getPointerSize();
        ByteBuffer buf = BufferUtils.createByteBuffer((int)PointerBuffer.getPointerSize());
        GL20.glGetVertexAttribPointer((int)index, (int)34373, (ByteBuffer)buf);
        long bufferAddress = buf.getLong(0);
        System.out.println(index + " bufferAddress = " + bufferAddress);
        return bufferAddress;
    }

    public static void main(String[] args) throws LWJGLException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, PrivilegedActionException {
        long posPointer;
        Display.create();
        int vbo = GL15.glGenBuffers();
        GL15.glBindBuffer((int)34962, (int)vbo);
        for (Attr attr : attributes) {
            GL20.glEnableVertexAttribArray((int)attr.index);
            posPointer = Test_glGetVertexAttribPointer_API_bug.glGetVertexAttribPointer(attr.index);
            if (posPointer != 0L) {
                throw new AssertionError();
            }
            GL20.glVertexAttribPointer((int)attr.index, (int)attr.size, (int)5126, (boolean)false, (int)strideBytes, (long)attr.getByteOffset());
        }
        for (Attr attr : attributes) {
            posPointer = Test_glGetVertexAttribPointer_API_bug.glGetVertexAttribPointer(attr.index);
            if (posPointer != attr.getByteOffset()) {
                throw new AssertionError((Object)"this will never happen");
            }
            System.out.println(attr.name + ": offset = " + posPointer);
        }
        if (!crashJvm) {
            System.out.println("Test passed, but try running again with -DcrashJvm=true.");
        } else {
            System.out.println("You won't ever get this far with LWJGL 2.8.5 or 2.9.0");
        }
    }

    static class AttrGen {
        int offset = 0;

        AttrGen() {
        }

        Attr allocAttr(String name, int index, int size) {
            Attr result = new Attr(name, index, size, this.offset);
            this.offset += size;
            return result;
        }
    }

    static class Attr {
        final String name;
        final int index;
        final int size;
        final int offset;

        Attr(String name, int index, int size, int offset) {
            this.name = name;
            this.index = index;
            this.size = size;
            this.offset = offset;
        }

        long getByteOffset() {
            return this.offset * 4;
        }
    }
}

