/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.lwjgl.opengl.GL11;

public class SignatureList {
    public static void main(String[] args) {
        Class<GL11> clazz = GL11.class;
        Method[] methods = clazz.getMethods();
        ArrayList<Method> sortedMethods = new ArrayList<Method>(methods.length);
        for (Method m : methods) {
            sortedMethods.add(m);
        }
        Collections.sort(sortedMethods, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                Class<?>[] params2;
                int cmp = o1.getName().compareTo(o2.getName());
                if (cmp != 0) {
                    return cmp;
                }
                Class<?>[] params1 = o1.getParameterTypes();
                cmp = Integer.compare(params1.length, (params2 = o2.getParameterTypes()).length);
                if (cmp != 0) {
                    return cmp;
                }
                for (int i = 0; i < params1.length; ++i) {
                    if (params1[i] == params2[i]) continue;
                    return params1[i].getSimpleName().compareTo(params2[i].getSimpleName());
                }
                return 0;
            }
        });
        for (Method m : sortedMethods) {
            if (!m.getName().startsWith("gl")) continue;
            Class<?>[] params = m.getParameterTypes();
            System.out.print(m.getName() + "(");
            boolean first = true;
            for (Class<?> p : params) {
                if (first) {
                    first = false;
                } else {
                    System.out.print(", ");
                }
                System.out.print(p.getSimpleName());
            }
            System.out.println(")");
        }
    }
}

